/******************************************************************/
/* This file contains memory and I/O management definitions       */
/* $Id: paristio.h,v 1.4 2000/07/11 18:45:23 igor Exp $ */

typedef unsigned char *byteptr;

typedef struct stackzone
{
  long zonetop, bot, top, avma, memused;
} stackzone;

typedef struct entree {
  char *name;
  ulong valence;
  void *value;
  long menu;
  char *code;
  struct entree *next;
  char *help;
  void *args;
} entree;

typedef struct PariOUT {
  void (*putch)(char);
  void (*puts)(char*);
  void (*flush)(void);     /* Finalize a report of a non fatal-error. */
  void (*die)(void);       /* If not-NULL, should be called to finalize
                          a report of a fatal error (no "\n" required). */
} PariOUT;

typedef struct pariFILE {
  FILE *file;
  int type;
  char *name;
  struct pariFILE* prev;
  struct pariFILE* next;
} pariFILE;
/* Common global variables: */

extern PariOUT *pariOut, *pariErr;
extern FILE    *pari_outfile, *logfile, *infile, *errfile;

extern ulong avma,bot,top,memused;
extern byteptr diffptr;
extern entree  **varentries;
extern char    *errmessage[], *current_psfile;

#define is_universal_constant(x) ((GEN)(x) >= gzero && (GEN)(x) <= gi)

#define copyifstack(x,y) {ulong t=(ulong)(x); \
			  (y)=(t>=bot &&t<top)? lcopy((GEN)t): t;}
#define icopyifstack(x,y) {ulong t=(ulong)(x); \
			  (y)=(t>=bot &&t<top)? licopy((GEN)t): t;}
#define isonstack(x) ((ulong)(x)>=bot && (ulong)(x)<top)

/* Define this to (1) locally (in a given file, NOT here) to check
 * "random" garbage collecting
 */
#ifdef DYNAMIC_STACK
#  define low_stack(x,l) (avma < (l))
#else
#  define low_stack(x,l) (avma < (x))
#endif

#define stack_lim(av,n) (bot + (((av)-bot)>>(n)))

#ifndef O_RDONLY
#  define O_RDONLY 0
#endif
#ifndef SIG_IGN
#  define SIG_IGN (void(*)())1
#endif
#ifndef SIGINT
#  define SIGINT 2
#endif
